/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.dsl.MappingEase;
import org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.embeddable.FluentEmbeddableMappingBuilder;
import org.codefilarete.stalactite.dsl.embeddable.FluentEmbeddableMappingBuilderManyToManyOptions;
import org.codefilarete.stalactite.dsl.embeddable.FluentEmbeddableMappingBuilderManyToOneOptions;
import org.codefilarete.stalactite.dsl.embeddable.FluentEmbeddableMappingBuilderOneToManyOptions;
import org.codefilarete.stalactite.dsl.embeddable.FluentEmbeddableMappingBuilderOneToOneOptions;
import org.codefilarete.stalactite.dsl.embeddable.FluentEmbeddableMappingConfiguration;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.entity.FluentEntityMappingBuilder;
import org.codefilarete.stalactite.dsl.idpolicy.IdentifierPolicy;
import org.codefilarete.stalactite.dsl.property.CascadeOptions;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.FluentEntityMappingConfigurationSupportManyToManyTest;
import org.codefilarete.stalactite.engine.JdbcForeignKey;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.model.City;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.stalactite.engine.model.book.AbstractEntity;
import org.codefilarete.stalactite.engine.model.book.Book;
import org.codefilarete.stalactite.engine.model.book.BusinessCategory;
import org.codefilarete.stalactite.engine.model.book.ImprintPublisher;
import org.codefilarete.stalactite.engine.model.book.Publisher;
import org.codefilarete.stalactite.engine.model.device.Address;
import org.codefilarete.stalactite.engine.model.device.Device;
import org.codefilarete.stalactite.engine.model.device.Location;
import org.codefilarete.stalactite.engine.model.device.Review;
import org.codefilarete.stalactite.engine.model.security.RecoveryQuestion;
import org.codefilarete.stalactite.engine.model.survey.Answer;
import org.codefilarete.stalactite.engine.model.survey.Choice;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.Length;
import org.codefilarete.stalactite.sql.ddl.Size;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.hsqldb.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.hsqldb.test.HSQLDBInMemoryDataSource;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class FluentEmbeddableWithRelationMappingConfigurationSupportTest {
    private final Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
    private final DataSource dataSource = new HSQLDBInMemoryDataSource();
    private PersistenceContext persistenceContext;

    @BeforeEach
    public void initTest() {
        this.dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        this.dialect.getSqlTypeRegistry().put(Identifier.class, "int");
        this.persistenceContext = new PersistenceContext(this.dataSource, this.dialect);
    }

    @Nested
    class ElementCollection_Embedded {
        ElementCollection_Embedded() {
        }

        @Test
        void foreignKeyIsCreated() {
            FluentEmbeddableMappingConfiguration.FluentEmbeddableMappingConfigurationElementCollectionImportEmbedOptions addressMappingBuilder = MappingEase.embeddableBuilder(Address.class).map(Address::getStreet).mapCollection(Location::getReviews, Review.class, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Review.class).map(Review::getRanking).map(Review::getComment));
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).embed(Device::setLocation, (EmbeddableMappingConfigurationProvider)addressMappingBuilder).build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ConfiguredPersister addressPersister = (ConfiguredPersister)devicePersister;
            Map tablePerName = Iterables.map((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext), Table::getName);
            JdbcForeignKey expectedForeignKey1 = new JdbcForeignKey("FK_Device_location_reviews_id_Device_id", "Device_location_reviews", "id", "Device", "id");
            Comparator<JdbcForeignKey> comparing = Comparator.comparing(JdbcForeignKey::getSignature, Comparator.naturalOrder());
            Assertions.assertThat((Collection)((Table)tablePerName.get("Device_location_reviews")).getForeignKeys()).extracting(JdbcForeignKey::new).usingElementComparator(comparing).containsExactlyInAnyOrder((Object[])new JdbcForeignKey[]{expectedForeignKey1});
        }

        @Test
        void foreignKeyIsCreated_reverseJoinColumn() {
            FluentEmbeddableMappingConfiguration.FluentEmbeddableMappingConfigurationElementCollectionImportEmbedOptions addressMappingBuilder = MappingEase.embeddableBuilder(Address.class).map(Address::getStreet).mapCollection(Location::getReviews, Review.class, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Review.class).map(Review::getRanking).mandatory().map(Review::getComment)).overrideName(Review::getComment, "verbatim").overrideSize(Review::getComment, (Size)Size.length((int)2000));
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).embed(Device::setLocation, (EmbeddableMappingConfigurationProvider)addressMappingBuilder).build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            Map tablePerName = Iterables.map((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext), Table::getName);
            Assertions.assertThat((Object)((Table)tablePerName.get("Device_location_reviews")).getColumn("verbatim")).isNotNull();
            Assertions.assertThat((Object)((Table)tablePerName.get("Device_location_reviews")).getColumn("verbatim").getSize()).extracting(Length.class::cast).extracting(Length::getValue).isEqualTo((Object)2000);
        }

        @Test
        void crud() {
            FluentEmbeddableMappingConfiguration.FluentEmbeddableMappingConfigurationElementCollectionImportEmbedOptions addressMappingBuilder = MappingEase.embeddableBuilder(Address.class).map(Address::getStreet).mapCollection(Location::getReviews, Review.class, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Review.class).map(Review::getRanking).mandatory().map(Review::getComment)).overrideName(Review::getComment, "verbatim").overrideSize(Review::getComment, (Size)Size.length((int)2000));
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).embed(Device::setLocation, (EmbeddableMappingConfigurationProvider)addressMappingBuilder).build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Device dummyDevice = new Device(13L);
            dummyDevice.setName("UPS");
            Address address = new Address();
            address.setStreet("221B Baker Street");
            Review review = new Review();
            review.setComment("fine place");
            review.setRanking(4);
            address.setReviews(Arrays.asHashSet((Object[])new Review[]{review}));
            dummyDevice.setLocation(address);
            devicePersister.insert((Object)dummyDevice);
            Device loadedDevice = (Device)devicePersister.select(dummyDevice.getId());
            Assertions.assertThat((Object)loadedDevice).usingRecursiveComparison().isEqualTo((Object)dummyDevice);
            Review anotherReview = new Review();
            anotherReview.setComment("awesome");
            anotherReview.setRanking(5);
            address.getReviews().add(anotherReview);
            devicePersister.update((Object)dummyDevice);
            loadedDevice = (Device)devicePersister.select(dummyDevice.getId());
            Assertions.assertThat((Object)loadedDevice).usingRecursiveComparison().isEqualTo((Object)dummyDevice);
            devicePersister.delete((Object)dummyDevice);
            Assertions.assertThat((Object)devicePersister.select(dummyDevice.getId())).isNull();
        }
    }

    @Nested
    class ManyToMany_MappedSuperClass {
        ManyToMany_MappedSuperClass() {
        }

        @Test
        void foreignKeyIsCreated() {
            FluentEmbeddableMappingBuilderManyToManyOptions answerBuilder = MappingEase.embeddableBuilder(Answer.class).map(Answer::getComment).mapManyToMany(Answer::getChoices, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Choice.class, Identifier.LONG_TYPE).mapKey(Choice::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Choice::getLabel)).indexed();
            FluentEntityMappingBuilder.FluentMappingBuilderEmbeddableMappingConfigurationImportedEmbedOptions mappingBuilder = MappingEase.entityBuilder(RecoveryQuestion.class, Long.class).mapKey(AbstractEntity::getId, (IdentifierPolicy)IdentifierPolicy.databaseAutoIncrement()).embed(RecoveryQuestion::getAnswer, (EmbeddableMappingConfigurationProvider)answerBuilder);
            mappingBuilder.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            Map tablePerName = Iterables.map((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext), Table::getName);
            JdbcForeignKey expectedForeignKey1 = new JdbcForeignKey("FK_RecoveryQuestion_answer_choices_recoveryQuestion_id_RecoveryQuestion_id", "RecoveryQuestion_answer_choices", "recoveryQuestion_id", "RecoveryQuestion", "id");
            JdbcForeignKey expectedForeignKey2 = new JdbcForeignKey("FK_RecoveryQuestion_answer_choices_answer_choices_id_Choice_id", "RecoveryQuestion_answer_choices", "answer_choices_id", "Choice", "id");
            Comparator<JdbcForeignKey> comparing = Comparator.comparing(JdbcForeignKey::getSignature, Comparator.naturalOrder());
            Assertions.assertThat((Collection)((Table)tablePerName.get("RecoveryQuestion_answer_choices")).getForeignKeys()).extracting(JdbcForeignKey::new).usingElementComparator(comparing).containsExactlyInAnyOrder((Object[])new JdbcForeignKey[]{expectedForeignKey1, expectedForeignKey2});
            Assertions.assertThat((Object)((Table)tablePerName.get("RecoveryQuestion_answer_choices")).getColumn("idx")).isNotNull();
        }

        @Test
        void foreignKeyIsCreated_indexedBy() {
            FluentEmbeddableMappingBuilderManyToManyOptions answerBuilder = MappingEase.embeddableBuilder(Answer.class).map(Answer::getComment).mapManyToMany(Answer::getChoices, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Choice.class, Identifier.LONG_TYPE).mapKey(Choice::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Choice::getLabel)).indexedBy("myIdx");
            FluentEntityMappingBuilder.FluentMappingBuilderEmbeddableMappingConfigurationImportedEmbedOptions mappingBuilder = MappingEase.entityBuilder(RecoveryQuestion.class, Long.class).mapKey(AbstractEntity::getId, (IdentifierPolicy)IdentifierPolicy.databaseAutoIncrement()).embed(RecoveryQuestion::getAnswer, (EmbeddableMappingConfigurationProvider)answerBuilder);
            mappingBuilder.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            Map tablePerName = Iterables.map((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext), Table::getName);
            JdbcForeignKey expectedForeignKey1 = new JdbcForeignKey("FK_RecoveryQuestion_answer_choices_recoveryQuestion_id_RecoveryQuestion_id", "RecoveryQuestion_answer_choices", "recoveryQuestion_id", "RecoveryQuestion", "id");
            JdbcForeignKey expectedForeignKey2 = new JdbcForeignKey("FK_RecoveryQuestion_answer_choices_answer_choices_id_Choice_id", "RecoveryQuestion_answer_choices", "answer_choices_id", "Choice", "id");
            Comparator<JdbcForeignKey> comparing = Comparator.comparing(JdbcForeignKey::getSignature, Comparator.naturalOrder());
            Assertions.assertThat((Collection)((Table)tablePerName.get("RecoveryQuestion_answer_choices")).getForeignKeys()).extracting(JdbcForeignKey::new).usingElementComparator(comparing).containsExactlyInAnyOrder((Object[])new JdbcForeignKey[]{expectedForeignKey1, expectedForeignKey2});
            Assertions.assertThat((Object)((Table)tablePerName.get("RecoveryQuestion_answer_choices")).getColumn("myIdx")).isNotNull();
        }

        @Test
        void crud() {
            FluentEmbeddableMappingBuilderManyToManyOptions answerBuilder = MappingEase.embeddableBuilder(Answer.class).map(Answer::getComment).mapManyToMany(Answer::getChoices, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Choice.class, Identifier.LONG_TYPE).mapKey(Choice::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Choice::getLabel)).indexed().initializeWith(KeepOrderSet::new);
            FluentEntityMappingBuilder.FluentMappingBuilderEmbeddableMappingConfigurationImportedEmbedOptions mappingBuilder = MappingEase.entityBuilder(RecoveryQuestion.class, Long.class).mapKey(AbstractEntity::getId, (IdentifierPolicy)IdentifierPolicy.databaseAutoIncrement()).embed(RecoveryQuestion::getAnswer, (EmbeddableMappingConfigurationProvider)answerBuilder);
            ConfiguredPersister recoveryQuestionPersister = (ConfiguredPersister)mappingBuilder.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Answer answer1 = new Answer(42L);
            Answer answer2 = new Answer(43L);
            Choice grenoble = new Choice(13L);
            grenoble.setLabel("Grenoble");
            Choice lyon = new Choice(17L);
            lyon.setLabel("Lyon");
            answer1.addChoices(lyon, grenoble);
            answer2.addChoices(grenoble, lyon);
            RecoveryQuestion question1 = new RecoveryQuestion();
            question1.setAnswer(answer1);
            RecoveryQuestion question2 = new RecoveryQuestion();
            question2.setAnswer(answer2);
            recoveryQuestionPersister.insert((Iterable)Arrays.asList((Object[])new RecoveryQuestion[]{question1, question2}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper trioExecutableQuery = FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext.newQuery((CharSequence)"select recoveryQuestion_id, answer_choices_id, idx from RecoveryQuestion_answer_choices", FluentEntityMappingConfigurationSupportManyToManyTest.Trio.class).mapKey(FluentEntityMappingConfigurationSupportManyToManyTest.Trio::forInteger, "recoveryQuestion_id", "answer_choices_id", "idx");
            Set choiceAnswerIds = (Set)trioExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choiceAnswerIds).containsExactlyInAnyOrder((Object[])new FluentEntityMappingConfigurationSupportManyToManyTest.Trio[]{new FluentEntityMappingConfigurationSupportManyToManyTest.Trio<Integer, Integer, Integer>(1, 17, 1), new FluentEntityMappingConfigurationSupportManyToManyTest.Trio<Integer, Integer, Integer>(1, 13, 2), new FluentEntityMappingConfigurationSupportManyToManyTest.Trio<Integer, Integer, Integer>(2, 13, 1), new FluentEntityMappingConfigurationSupportManyToManyTest.Trio<Integer, Integer, Integer>(2, 17, 2)});
            RecoveryQuestion loadedQuestion1 = (RecoveryQuestion)recoveryQuestionPersister.select((Object)question1.getId());
            Assertions.assertThat(loadedQuestion1.getAnswer().getChoices()).isInstanceOf(KeepOrderSet.class);
            Assertions.assertThat(loadedQuestion1.getAnswer().getChoices()).containsExactly((Object[])new Choice[]{lyon, grenoble});
            RecoveryQuestion loadedQuestion2 = (RecoveryQuestion)recoveryQuestionPersister.select((Object)question2.getId());
            Assertions.assertThat(loadedQuestion2.getAnswer().getChoices()).isInstanceOf(KeepOrderSet.class);
            Assertions.assertThat(loadedQuestion2.getAnswer().getChoices()).containsExactly((Object[])new Choice[]{grenoble, lyon});
        }

        @Test
        void crud_bidirectionality() {
            FluentEmbeddableMappingBuilderManyToManyOptions answerBuilder = MappingEase.embeddableBuilder(Answer.class).map(Answer::getComment).mapManyToMany(Answer::getChoices, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Choice.class, Identifier.LONG_TYPE).mapKey(Choice::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Choice::getLabel)).reverseCollection(Choice::getAnswers);
            FluentEntityMappingBuilder.FluentMappingBuilderEmbeddableMappingConfigurationImportedEmbedOptions mappingBuilder = MappingEase.entityBuilder(RecoveryQuestion.class, Long.class).mapKey(AbstractEntity::getId, (IdentifierPolicy)IdentifierPolicy.databaseAutoIncrement()).embed(RecoveryQuestion::getAnswer, (EmbeddableMappingConfigurationProvider)answerBuilder);
            ConfiguredPersister recoveryQuestionPersister = (ConfiguredPersister)mappingBuilder.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Answer answer1 = new Answer();
            answer1.setComment("42");
            Answer answer2 = new Answer();
            answer2.setComment("43");
            Choice grenoble = new Choice(13L);
            grenoble.setLabel("Grenoble");
            Choice lyon = new Choice(17L);
            lyon.setLabel("Lyon");
            answer1.addChoices(lyon, grenoble);
            answer2.addChoices(grenoble, lyon);
            RecoveryQuestion question1 = new RecoveryQuestion();
            question1.setAnswer(answer1);
            RecoveryQuestion question2 = new RecoveryQuestion();
            question2.setAnswer(answer2);
            recoveryQuestionPersister.insert((Iterable)Arrays.asList((Object[])new RecoveryQuestion[]{question1, question2}));
            RecoveryQuestion loadedQuestion1 = (RecoveryQuestion)recoveryQuestionPersister.select((Object)question1.getId());
            Assertions.assertThat(loadedQuestion1.getAnswer().getChoices().stream().flatMap(choice -> choice.getAnswers().stream())).hasSameElementsAs((Iterable)Arrays.asSet((Object[])new Answer[]{loadedQuestion1.getAnswer()}));
        }
    }

    @Nested
    class ManyToOne_Embedded {
        ManyToOne_Embedded() {
        }

        @Test
        void foreignKeyIsCreated() {
            FluentEmbeddableMappingBuilderManyToOneOptions publisherEntityBuilder = MappingEase.embeddableBuilder(Publisher.class).map(Publisher::getName).mapManyToOne(Publisher::getCategory, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(BusinessCategory.class, Long.class).mapKey(AbstractEntity::getId, (IdentifierPolicy)IdentifierPolicy.databaseAutoIncrement()).map(BusinessCategory::getName));
            FluentEntityMappingBuilder.FluentMappingBuilderEmbeddableMappingConfigurationImportedEmbedOptions mappingBuilder = MappingEase.entityBuilder(Book.class, Long.class).mapKey(AbstractEntity::getId, (IdentifierPolicy)IdentifierPolicy.databaseAutoIncrement()).map(Book::getIsbn).map(Book::getPrice).map(Book::getTitle).embed(Book::getEbookPublisher, (EmbeddableMappingConfigurationProvider)publisherEntityBuilder);
            mappingBuilder.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            Map tablePerName = Iterables.map((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext), Table::getName);
            JdbcForeignKey expectedForeignKey1 = new JdbcForeignKey("FK_Book_ebookPublisher_categoryId_BusinessCategory_id", "Book", "ebookPublisher_categoryId", "BusinessCategory", "id");
            Comparator<JdbcForeignKey> comparing = Comparator.comparing(JdbcForeignKey::getSignature, Comparator.naturalOrder());
            Assertions.assertThat((Collection)((Table)tablePerName.get("Book")).getForeignKeys()).extracting(JdbcForeignKey::new).usingElementComparator(comparing).containsExactlyInAnyOrder((Object[])new JdbcForeignKey[]{expectedForeignKey1});
        }

        @Test
        void foreignKeyIsCreated_columnName() {
            FluentEmbeddableMappingBuilderManyToOneOptions publisherEntityBuilder = MappingEase.embeddableBuilder(Publisher.class).map(Publisher::getName).mapManyToOne(Publisher::getCategory, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(BusinessCategory.class, Long.class).mapKey(AbstractEntity::getId, (IdentifierPolicy)IdentifierPolicy.databaseAutoIncrement()).map(BusinessCategory::getName)).columnName("catId");
            FluentEntityMappingBuilder.FluentMappingBuilderEmbeddableMappingConfigurationImportedEmbedOptions mappingBuilder = MappingEase.entityBuilder(Book.class, Long.class).mapKey(AbstractEntity::getId, (IdentifierPolicy)IdentifierPolicy.databaseAutoIncrement()).map(Book::getIsbn).map(Book::getPrice).map(Book::getTitle).embed(Book::getEbookPublisher, (EmbeddableMappingConfigurationProvider)publisherEntityBuilder);
            mappingBuilder.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            Map tablePerName = Iterables.map((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext), Table::getName);
            JdbcForeignKey expectedForeignKey1 = new JdbcForeignKey("FK_Book_catId_BusinessCategory_id", "Book", "catId", "BusinessCategory", "id");
            Comparator<JdbcForeignKey> comparing = Comparator.comparing(JdbcForeignKey::getSignature, Comparator.naturalOrder());
            Assertions.assertThat((Collection)((Table)tablePerName.get("Book")).getForeignKeys()).extracting(JdbcForeignKey::new).usingElementComparator(comparing).containsExactlyInAnyOrder((Object[])new JdbcForeignKey[]{expectedForeignKey1});
        }

        @Test
        void crud() {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions categoryBuilder = MappingEase.entityBuilder(BusinessCategory.class, Long.class).mapKey(AbstractEntity::getId, (IdentifierPolicy)IdentifierPolicy.databaseAutoIncrement()).map(BusinessCategory::getName);
            FluentEmbeddableMappingBuilderManyToOneOptions publisherEntityBuilder = MappingEase.embeddableBuilder(Publisher.class).map(Publisher::getName).mapManyToOne(Publisher::getCategory, (EntityMappingConfigurationProvider)categoryBuilder).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL);
            FluentEntityMappingBuilder.FluentMappingBuilderEmbeddableMappingConfigurationImportedEmbedOptions mappingBuilder = MappingEase.entityBuilder(Book.class, Long.class).mapKey(AbstractEntity::getId, (IdentifierPolicy)IdentifierPolicy.databaseAutoIncrement()).map(Book::getIsbn).map(Book::getPrice).map(Book::getTitle).embed(Book::getEbookPublisher, (EmbeddableMappingConfigurationProvider)publisherEntityBuilder);
            EntityPersister bookPersister = mappingBuilder.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            ConfiguredPersister categoryPersister = (ConfiguredPersister)categoryBuilder.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            Book book1 = new Book("a first book", 24.1, "AAA-BBB-CCC");
            Book book2 = new Book("a second book", 33.5, "XXX-YYY-ZZZ");
            BusinessCategory academicCategory = new BusinessCategory("Academic");
            Publisher ebookPublisher1 = new Publisher();
            ebookPublisher1.setName("Amazon");
            ebookPublisher1.setCategory(academicCategory);
            book1.setEbookPublisher(ebookPublisher1);
            BusinessCategory generalCategory = new BusinessCategory("General public");
            Publisher ebookPublisher2 = new Publisher();
            ebookPublisher2.setName("Kobo");
            ebookPublisher2.setCategory(generalCategory);
            book2.setEbookPublisher(ebookPublisher2);
            bookPersister.insert((Iterable)Arrays.asList((Object[])new Book[]{book1, book2}));
            Set loadedBooks = bookPersister.select((Object[])new Long[]{book1.getId(), book2.getId()});
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)loadedBooks).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new Book[]{book1, book2});
            BusinessCategory educationalCategory = new BusinessCategory("Educational");
            Publisher ebookPublisher3 = new Publisher();
            ebookPublisher3.setName("Google");
            ebookPublisher3.setCategory(educationalCategory);
            book1.setEbookPublisher(ebookPublisher3);
            bookPersister.update((Object)book1);
            loadedBooks = bookPersister.select((Object[])new Long[]{book1.getId(), book2.getId()});
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)loadedBooks).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new Book[]{book1, book2});
            bookPersister.delete((Object)book1);
            Set categories = categoryPersister.select((Object[])new Long[]{academicCategory.getId(), generalCategory.getId(), educationalCategory.getId()});
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)categories).usingRecursiveFieldByFieldElementComparator()).containsExactly((Object[])new BusinessCategory[]{generalCategory});
        }
    }

    @Nested
    class ManyToOne_MappedSuperClass {
        ManyToOne_MappedSuperClass() {
        }

        @Test
        void foreignKeyIsCreated() {
            FluentEmbeddableMappingBuilderManyToOneOptions publisherEntityBuilder = MappingEase.embeddableBuilder(Publisher.class).map(Publisher::getName).mapManyToOne(Publisher::getCategory, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(BusinessCategory.class, Long.class).mapKey(AbstractEntity::getId, (IdentifierPolicy)IdentifierPolicy.databaseAutoIncrement()).map(BusinessCategory::getName));
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions addressMappingBuilder = MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).mapKey(Location::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getStreet).mandatory();
            FluentEntityMappingBuilder mappingBuilder = MappingEase.entityBuilder(ImprintPublisher.class, Long.class).mapKey(AbstractEntity::getId, (IdentifierPolicy)IdentifierPolicy.databaseAutoIncrement()).mapOneToOne(ImprintPublisher::getPrintingWorkLocation, (EntityMappingConfigurationProvider)addressMappingBuilder).mapSuperClass((EmbeddableMappingConfigurationProvider)publisherEntityBuilder);
            mappingBuilder.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            Map tablePerName = Iterables.map((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext), Table::getName);
            JdbcForeignKey expectedForeignKey1 = new JdbcForeignKey("FK_ImprintPublisher_printingWorkLocationId_Address_id", "ImprintPublisher", "printingWorkLocationId", "Address", "id");
            JdbcForeignKey expectedForeignKey2 = new JdbcForeignKey("FK_ImprintPublisher_categoryId_BusinessCategory_id", "ImprintPublisher", "categoryId", "BusinessCategory", "id");
            Comparator<JdbcForeignKey> comparing = Comparator.comparing(JdbcForeignKey::getSignature, Comparator.naturalOrder());
            Assertions.assertThat((Collection)((Table)tablePerName.get("ImprintPublisher")).getForeignKeys()).extracting(JdbcForeignKey::new).usingElementComparator(comparing).containsExactlyInAnyOrder((Object[])new JdbcForeignKey[]{expectedForeignKey1, expectedForeignKey2});
        }

        @Test
        void foreignKeyIsCreated_columnName() {
            FluentEmbeddableMappingBuilderManyToOneOptions publisherEntityBuilder = MappingEase.embeddableBuilder(Publisher.class).map(Publisher::getName).mapManyToOne(Publisher::getCategory, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(BusinessCategory.class, Long.class).mapKey(AbstractEntity::getId, (IdentifierPolicy)IdentifierPolicy.databaseAutoIncrement()).map(BusinessCategory::getName)).columnName("catId");
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions addressMappingBuilder = MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).mapKey(Location::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getStreet).mandatory();
            FluentEntityMappingBuilder mappingBuilder = MappingEase.entityBuilder(ImprintPublisher.class, Long.class).mapKey(AbstractEntity::getId, (IdentifierPolicy)IdentifierPolicy.databaseAutoIncrement()).mapOneToOne(ImprintPublisher::getPrintingWorkLocation, (EntityMappingConfigurationProvider)addressMappingBuilder).mapSuperClass((EmbeddableMappingConfigurationProvider)publisherEntityBuilder);
            mappingBuilder.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            Map tablePerName = Iterables.map((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext), Table::getName);
            JdbcForeignKey expectedForeignKey1 = new JdbcForeignKey("FK_ImprintPublisher_printingWorkLocationId_Address_id", "ImprintPublisher", "printingWorkLocationId", "Address", "id");
            JdbcForeignKey expectedForeignKey2 = new JdbcForeignKey("FK_ImprintPublisher_catId_BusinessCategory_id", "ImprintPublisher", "catId", "BusinessCategory", "id");
            Comparator<JdbcForeignKey> comparing = Comparator.comparing(JdbcForeignKey::getSignature, Comparator.naturalOrder());
            Assertions.assertThat((Collection)((Table)tablePerName.get("ImprintPublisher")).getForeignKeys()).extracting(JdbcForeignKey::new).usingElementComparator(comparing).containsExactlyInAnyOrder((Object[])new JdbcForeignKey[]{expectedForeignKey1, expectedForeignKey2});
        }

        @Test
        void crud() {
            FluentEmbeddableMappingBuilderManyToOneOptions publisherEntityBuilder = MappingEase.embeddableBuilder(Publisher.class).map(Publisher::getName).mapManyToOne(Publisher::getCategory, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(BusinessCategory.class, Long.class).mapKey(AbstractEntity::getId, (IdentifierPolicy)IdentifierPolicy.databaseAutoIncrement()).map(BusinessCategory::getName));
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions addressMappingBuilder = MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).mapKey(Location::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getStreet).mandatory();
            FluentEntityMappingBuilder mappingBuilder = MappingEase.entityBuilder(ImprintPublisher.class, Long.class).mapKey(AbstractEntity::getId, (IdentifierPolicy)IdentifierPolicy.databaseAutoIncrement()).mapOneToOne(ImprintPublisher::getPrintingWorkLocation, (EntityMappingConfigurationProvider)addressMappingBuilder).mapSuperClass((EmbeddableMappingConfigurationProvider)publisherEntityBuilder);
            EntityPersister imprintPersister = mappingBuilder.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Address address = new Address(42L);
            address.setStreet("221B Baker Street");
            BusinessCategory academicCategory = new BusinessCategory("Academic");
            ImprintPublisher ebookPublisher1 = new ImprintPublisher();
            ebookPublisher1.setName("Amazon");
            ebookPublisher1.setCategory(academicCategory);
            BusinessCategory generalCategory = new BusinessCategory("General public");
            ImprintPublisher ebookPublisher2 = new ImprintPublisher();
            ebookPublisher2.setName("Kobo");
            ebookPublisher2.setCategory(generalCategory);
            imprintPersister.insert((Iterable)Arrays.asList((Object[])new ImprintPublisher[]{ebookPublisher1, ebookPublisher2}));
            Set loadedImprints = imprintPersister.select((Object[])new Long[]{ebookPublisher1.getId(), ebookPublisher2.getId()});
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)loadedImprints).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new ImprintPublisher[]{ebookPublisher1, ebookPublisher2});
            BusinessCategory educationalCategory = new BusinessCategory("Educational");
            ebookPublisher2.setCategory(educationalCategory);
            imprintPersister.update((Object)ebookPublisher2);
            loadedImprints = imprintPersister.select((Object[])new Long[]{ebookPublisher1.getId(), ebookPublisher2.getId()});
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)loadedImprints).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new ImprintPublisher[]{ebookPublisher1, ebookPublisher2});
            imprintPersister.delete((Object)ebookPublisher2);
            Assertions.assertThat((Object)imprintPersister.select((Object)ebookPublisher2.getId())).isNull();
        }
    }

    @Nested
    class OneToMany_Embedded {
        OneToMany_Embedded() {
        }

        @Test
        void foreignKeyIsCreated() {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions reviewConfiguration = MappingEase.entityBuilder(Review.class, Identifier.LONG_TYPE).mapKey(Review::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Review::getRanking);
            FluentEmbeddableMappingBuilderOneToManyOptions locationMappingBuilder = MappingEase.embeddableBuilder(Location.class).mapOneToMany(Location::getReviews, (EntityMappingConfigurationProvider)reviewConfiguration);
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).embed(Device::setLocation, (EmbeddableMappingConfigurationProvider)locationMappingBuilder).build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            Map tablePerName = Iterables.map((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext), Table::getName);
            JdbcForeignKey expectedForeignKey1 = new JdbcForeignKey("FK_Device_location_reviews_location_reviews_id_Review_id", "Device_location_reviews", "location_reviews_id", "Review", "id");
            JdbcForeignKey expectedForeignKey2 = new JdbcForeignKey("FK_Device_location_reviews_device_id_Device_id", "Device_location_reviews", "device_id", "Device", "id");
            Comparator<JdbcForeignKey> comparing = Comparator.comparing(JdbcForeignKey::getSignature, Comparator.naturalOrder());
            Assertions.assertThat((Collection)((Table)tablePerName.get("Device_location_reviews")).getForeignKeys()).extracting(JdbcForeignKey::new).usingElementComparator(comparing).containsExactlyInAnyOrder((Object[])new JdbcForeignKey[]{expectedForeignKey1, expectedForeignKey2});
        }

        @Test
        void foreignKeyIsCreated_mappedBy() {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions reviewConfiguration = MappingEase.entityBuilder(Review.class, Identifier.LONG_TYPE).mapKey(Review::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Review::getRanking).mandatory();
            FluentEmbeddableMappingBuilderOneToManyOptions locationMappingBuilder = MappingEase.embeddableBuilder(Location.class).mapOneToMany(Location::getReviews, (EntityMappingConfigurationProvider)reviewConfiguration).mappedBy(Review::getLocation);
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).embed(Device::setLocation, (EmbeddableMappingConfigurationProvider)locationMappingBuilder).build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            Map tablePerName = Iterables.map((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext), Table::getName);
            Comparator<JdbcForeignKey> comparing = Comparator.comparing(JdbcForeignKey::getSignature, Comparator.naturalOrder());
            Assertions.assertThat((Collection)((Table)tablePerName.get("Device")).getForeignKeys()).isEmpty();
            JdbcForeignKey expectedForeignKey1 = new JdbcForeignKey("FK_Review_location_locationId_Device_id", "Review", "location_locationId", "Device", "id");
            Assertions.assertThat((Collection)((Table)tablePerName.get("Review")).getForeignKeys()).extracting(JdbcForeignKey::new).usingElementComparator(comparing).containsExactlyInAnyOrder((Object[])new JdbcForeignKey[]{expectedForeignKey1});
        }

        @Test
        void mappedByGetter_crud() {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions reviewConfiguration = MappingEase.entityBuilder(Review.class, Identifier.LONG_TYPE).mapKey(Review::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Review::getRanking).mandatory();
            FluentEmbeddableMappingBuilder locationMappingBuilder = MappingEase.embeddableBuilder(Address.class).map(Address::getStreet).mapSuperClass((EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Location.class).mapOneToMany(Location::getReviews, (EntityMappingConfigurationProvider)reviewConfiguration).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mappedBy(Review::getLocation));
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).embed(Device::setLocation, (EmbeddableMappingConfigurationProvider)locationMappingBuilder).build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            EntityPersister reviewPersister = reviewConfiguration.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            Device dummyDevice = new Device(13L);
            dummyDevice.setName("UPS");
            Address address = new Address();
            address.setStreet("221B Baker Street");
            address.setReviews(Arrays.asHashSet((Object[])new Review[]{new Review(1L), new Review(2L), new Review(3L)}));
            dummyDevice.setLocation(address);
            devicePersister.insert((Object)dummyDevice);
            Device loadedDevice = (Device)devicePersister.select(dummyDevice.getId());
            Assertions.assertThat((Object)loadedDevice).usingRecursiveComparison().ignoringFields(new String[]{"location.reviews.location"}).isEqualTo((Object)dummyDevice);
            Assertions.assertThat((Collection)loadedDevice.getLocation().getReviews().stream().map(Review::getLocation).collect(Collectors.toSet())).containsOnly((Object[])new Location[]{loadedDevice.getLocation()});
            address.getReviews().add(new Review(4L));
            devicePersister.update((Object)dummyDevice);
            loadedDevice = (Device)devicePersister.select(dummyDevice.getId());
            Assertions.assertThat((Object)loadedDevice).usingRecursiveComparison().ignoringFields(new String[]{"location.reviews.location"}).isEqualTo((Object)dummyDevice);
            Assertions.assertThat((Collection)loadedDevice.getLocation().getReviews().stream().map(Review::getLocation).collect(Collectors.toSet())).containsOnly((Object[])new Location[]{loadedDevice.getLocation()});
            devicePersister.delete((Object)dummyDevice);
            Assertions.assertThat((Object)devicePersister.select(dummyDevice.getId())).isNull();
            Assertions.assertThat((Collection)reviewPersister.select((Iterable)address.getReviews().stream().map(Review::getId).collect(Collectors.toSet()))).isEmpty();
        }

        @Test
        void mappedBySetter_crud() {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions reviewConfiguration = MappingEase.entityBuilder(Review.class, Identifier.LONG_TYPE).mapKey(Review::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Review::getRanking).mandatory();
            FluentEmbeddableMappingBuilderOneToManyOptions locationMappingBuilder = MappingEase.embeddableBuilder(Address.class).map(Address::getStreet).mapOneToMany(Location::getReviews, (EntityMappingConfigurationProvider)reviewConfiguration).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mappedBy(Review::setLocation);
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).embed(Device::setLocation, (EmbeddableMappingConfigurationProvider)locationMappingBuilder).build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            EntityPersister reviewPersister = reviewConfiguration.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            Device dummyDevice = new Device(13L);
            dummyDevice.setName("UPS");
            Address address = new Address();
            address.setStreet("221B Baker Street");
            address.setReviews(Arrays.asHashSet((Object[])new Review[]{new Review(1L), new Review(2L), new Review(3L)}));
            dummyDevice.setLocation(address);
            devicePersister.insert((Object)dummyDevice);
            Device loadedDevice = (Device)devicePersister.select(dummyDevice.getId());
            Assertions.assertThat((Object)loadedDevice).usingRecursiveComparison().ignoringFields(new String[]{"location.reviews.location"}).isEqualTo((Object)dummyDevice);
            Assertions.assertThat((Collection)loadedDevice.getLocation().getReviews().stream().map(Review::getLocation).collect(Collectors.toSet())).containsOnly((Object[])new Location[]{loadedDevice.getLocation()});
            address.getReviews().add(new Review(4L));
            devicePersister.update((Object)dummyDevice);
            loadedDevice = (Device)devicePersister.select(dummyDevice.getId());
            Assertions.assertThat((Object)loadedDevice).usingRecursiveComparison().ignoringFields(new String[]{"location.reviews.location"}).isEqualTo((Object)dummyDevice);
            Assertions.assertThat((Collection)loadedDevice.getLocation().getReviews().stream().map(Review::getLocation).collect(Collectors.toSet())).containsOnly((Object[])new Location[]{loadedDevice.getLocation()});
            devicePersister.delete((Object)dummyDevice);
            Assertions.assertThat((Object)devicePersister.select(dummyDevice.getId())).isNull();
            Assertions.assertThat((Collection)reviewPersister.select((Iterable)address.getReviews().stream().map(Review::getId).collect(Collectors.toSet()))).isEmpty();
        }
    }

    @Nested
    class OneToMany_MappedSuperClass {
        OneToMany_MappedSuperClass() {
        }

        @Test
        void foreignKeyIsCreated() {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions reviewConfiguration = MappingEase.entityBuilder(Review.class, Identifier.LONG_TYPE).mapKey(Review::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Review::getRanking).mandatory();
            FluentEmbeddableMappingBuilderOneToManyOptions locationMappingBuilder = MappingEase.embeddableBuilder(Location.class).mapOneToMany(Location::getReviews, (EntityMappingConfigurationProvider)reviewConfiguration).mappedBy(Review::getLocation);
            FluentEntityMappingBuilder addressMappingBuilder = MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).mapKey(Location::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getStreet).mandatory().mapOneToOne(Address::getCity, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName).mandatory()).mapSuperClass((EmbeddableMappingConfigurationProvider)locationMappingBuilder);
            addressMappingBuilder.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            Map tablePerName = Iterables.map((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext), Table::getName);
            JdbcForeignKey expectedForeignKey1 = new JdbcForeignKey("FK_Address_cityId_City_id", "Address", "cityId", "City", "id");
            Comparator<JdbcForeignKey> comparing = Comparator.comparing(JdbcForeignKey::getSignature, Comparator.naturalOrder());
            Assertions.assertThat((Collection)((Table)tablePerName.get("Address")).getForeignKeys()).extracting(JdbcForeignKey::new).usingElementComparator(comparing).containsExactlyInAnyOrder((Object[])new JdbcForeignKey[]{expectedForeignKey1});
            JdbcForeignKey expectedForeignKey2 = new JdbcForeignKey("FK_Review_locationId_Address_id", "Review", "locationId", "Address", "id");
            Assertions.assertThat((Collection)((Table)tablePerName.get("Review")).getForeignKeys()).extracting(JdbcForeignKey::new).usingElementComparator(comparing).containsExactlyInAnyOrder((Object[])new JdbcForeignKey[]{expectedForeignKey2});
        }

        @Test
        void crud() {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions reviewConfiguration = MappingEase.entityBuilder(Review.class, Identifier.LONG_TYPE).mapKey(Review::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Review::getRanking).mandatory();
            FluentEmbeddableMappingBuilderOneToManyOptions locationMappingBuilder = MappingEase.embeddableBuilder(Location.class).mapOneToMany(Location::getReviews, (EntityMappingConfigurationProvider)reviewConfiguration).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mappedBy(Review::getLocation);
            FluentEntityMappingBuilder addressMappingBuilder = MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).mapKey(Location::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getStreet).mandatory().mapOneToOne(Address::getCity, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName).mandatory()).mapSuperClass((EmbeddableMappingConfigurationProvider)locationMappingBuilder);
            EntityPersister addressPersister = addressMappingBuilder.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            ConfiguredPersister reviewPersister = (ConfiguredPersister)reviewConfiguration.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            Address address = new Address(42L);
            address.setStreet("221B Baker Street");
            City city = new City(111L);
            city.setName("Grenoble");
            address.setCity(city);
            address.setReviews(Arrays.asHashSet((Object[])new Review[]{new Review(1L), new Review(2L), new Review(3L)}));
            addressPersister.insert((Object)address);
            Address loadedAddress = (Address)addressPersister.select(address.getId());
            Assertions.assertThat((Object)loadedAddress).usingRecursiveComparison().ignoringFields(new String[]{"reviews.location"}).isEqualTo((Object)address);
            Assertions.assertThat((Collection)loadedAddress.getReviews().stream().map(Review::getLocation).collect(Collectors.toSet())).containsOnly((Object[])new Location[]{loadedAddress});
            address.getReviews().add(new Review(4L));
            addressPersister.update((Object)address);
            loadedAddress = (Address)addressPersister.select(address.getId());
            Assertions.assertThat((Object)loadedAddress).usingRecursiveComparison().ignoringFields(new String[]{"reviews.location"}).isEqualTo((Object)address);
            Assertions.assertThat((Collection)loadedAddress.getReviews().stream().map(Review::getLocation).collect(Collectors.toSet())).containsOnly((Object[])new Location[]{loadedAddress});
            addressPersister.delete((Object)address);
            Assertions.assertThat((Collection)reviewPersister.select((Iterable)address.getReviews().stream().map(Review::getId).collect(Collectors.toSet()))).isEmpty();
        }
    }

    @Nested
    class OneToOne_Embedded {
        OneToOne_Embedded() {
        }

        @Test
        void foreignKeyIsCreated() {
            FluentEmbeddableMappingBuilderOneToOneOptions addressMappingBuilder = MappingEase.embeddableBuilder(Address.class).map(Address::getStreet).mapOneToOne(Address::getCity, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName).mandatory());
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).embed(Device::setLocation, (EmbeddableMappingConfigurationProvider)addressMappingBuilder).build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ConfiguredPersister addressPersister = (ConfiguredPersister)devicePersister;
            JdbcForeignKey expectedForeignKey1 = new JdbcForeignKey("FK_Device_location_cityId_City_id", "Device", "location_cityId", "City", "id");
            Comparator<JdbcForeignKey> comparing = Comparator.comparing(JdbcForeignKey::getSignature, Comparator.naturalOrder());
            Assertions.assertThat((Collection)addressPersister.getMapping().getTargetTable().getForeignKeys()).extracting(JdbcForeignKey::new).usingElementComparator(comparing).containsExactlyInAnyOrder((Object[])new JdbcForeignKey[]{expectedForeignKey1});
        }

        @Test
        void foreignKeyIsCreated_columnName() {
            FluentEmbeddableMappingBuilderOneToOneOptions addressMappingBuilder = MappingEase.embeddableBuilder(Address.class).map(Address::getStreet).mapOneToOne(Address::getCity, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName).mandatory()).columnName("cityId");
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).embed(Device::setLocation, (EmbeddableMappingConfigurationProvider)addressMappingBuilder).build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ConfiguredPersister addressPersister = (ConfiguredPersister)devicePersister;
            JdbcForeignKey expectedForeignKey1 = new JdbcForeignKey("FK_Device_cityId_City_id", "Device", "cityId", "City", "id");
            Comparator<JdbcForeignKey> comparing = Comparator.comparing(JdbcForeignKey::getSignature, Comparator.naturalOrder());
            Assertions.assertThat((Collection)addressPersister.getMapping().getTargetTable().getForeignKeys()).extracting(JdbcForeignKey::new).usingElementComparator(comparing).containsExactlyInAnyOrder((Object[])new JdbcForeignKey[]{expectedForeignKey1});
        }

        @Test
        void crud() {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions cityConfiguration = MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName).mandatory();
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).embed(Device::setLocation, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Address.class).map(Address::getStreet).mapOneToOne(Address::getCity, (EntityMappingConfigurationProvider)cityConfiguration).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL)).build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            EntityPersister cityPersister = cityConfiguration.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Device dummyDevice = new Device(13L);
            dummyDevice.setName("UPS");
            Address address = new Address();
            address.setStreet("221B Baker Street");
            City city = new City(111L);
            city.setName("France");
            address.setCity(city);
            dummyDevice.setLocation(address);
            devicePersister.insert((Object)dummyDevice);
            Device loadedDevice = (Device)devicePersister.select(dummyDevice.getId());
            Assertions.assertThat((Object)loadedDevice).usingRecursiveComparison().isEqualTo((Object)dummyDevice);
            City city1 = new City(22L);
            city1.setName("Spain");
            address.setCity(city1);
            devicePersister.update((Object)dummyDevice);
            loadedDevice = (Device)devicePersister.select(dummyDevice.getId());
            Assertions.assertThat((Object)loadedDevice).usingRecursiveComparison().isEqualTo((Object)dummyDevice);
            devicePersister.delete((Object)dummyDevice);
            Assertions.assertThat((Object)devicePersister.select(dummyDevice.getId())).isNull();
            Assertions.assertThat((Object)cityPersister.select(city1.getId())).isNull();
        }
    }

    @Nested
    class OneToOne_MappedSuperClass {
        OneToOne_MappedSuperClass() {
        }

        @Test
        void foreignKeyIsCreated() {
            FluentEmbeddableMappingBuilderOneToOneOptions locationMappingBuilder = MappingEase.embeddableBuilder(Location.class).mapOneToOne(Location::getCountry, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).mandatory());
            FluentEntityMappingBuilder addressMappingBuilder = MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).mapKey(Location::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getStreet).mandatory().mapOneToOne(Address::getCity, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName).mandatory()).mapSuperClass((EmbeddableMappingConfigurationProvider)locationMappingBuilder);
            ConfiguredPersister addressPersister = (ConfiguredPersister)addressMappingBuilder.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            JdbcForeignKey expectedForeignKey1 = new JdbcForeignKey("FK_Address_cityId_City_id", "Address", "cityId", "City", "id");
            JdbcForeignKey expectedForeignKey2 = new JdbcForeignKey("FK_Address_countryId_Country_id", "Address", "countryId", "Country", "id");
            Comparator<JdbcForeignKey> comparing = Comparator.comparing(JdbcForeignKey::getSignature, Comparator.naturalOrder());
            Assertions.assertThat((Collection)addressPersister.getMapping().getTargetTable().getForeignKeys()).extracting(JdbcForeignKey::new).usingElementComparator(comparing).containsExactlyInAnyOrder((Object[])new JdbcForeignKey[]{expectedForeignKey1, expectedForeignKey2});
        }

        @Test
        void foreignKeyIsCreated_columnName() {
            FluentEmbeddableMappingBuilderOneToOneOptions locationMappingBuilder = MappingEase.embeddableBuilder(Location.class).mapOneToOne(Location::getCountry, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).mandatory()).columnName("country");
            FluentEntityMappingBuilder addressMappingBuilder = MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).mapKey(Location::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getStreet).mandatory().mapOneToOne(Address::getCity, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName).mandatory()).mapSuperClass((EmbeddableMappingConfigurationProvider)locationMappingBuilder);
            ConfiguredPersister addressPersister = (ConfiguredPersister)addressMappingBuilder.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            JdbcForeignKey expectedForeignKey1 = new JdbcForeignKey("FK_Address_cityId_City_id", "Address", "cityId", "City", "id");
            JdbcForeignKey expectedForeignKey2 = new JdbcForeignKey("FK_Address_country_Country_id", "Address", "country", "Country", "id");
            Comparator<JdbcForeignKey> comparing = Comparator.comparing(JdbcForeignKey::getSignature, Comparator.naturalOrder());
            Assertions.assertThat((Collection)addressPersister.getMapping().getTargetTable().getForeignKeys()).extracting(JdbcForeignKey::new).usingElementComparator(comparing).containsExactlyInAnyOrder((Object[])new JdbcForeignKey[]{expectedForeignKey1, expectedForeignKey2});
        }

        @Test
        void crud() {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions countryConfiguration = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).mandatory();
            FluentEmbeddableMappingBuilderOneToOneOptions locationMappingBuilder = MappingEase.embeddableBuilder(Location.class).mapOneToOne(Location::getCountry, (EntityMappingConfigurationProvider)countryConfiguration).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL);
            FluentEntityMappingBuilder addressMappingBuilder = MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).mapKey(Location::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getStreet).mandatory().mapOneToOne(Address::getCity, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName).mandatory()).mapSuperClass((EmbeddableMappingConfigurationProvider)locationMappingBuilder);
            EntityPersister countryPersister = countryConfiguration.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ConfiguredPersister addressPersister = (ConfiguredPersister)addressMappingBuilder.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Address address = new Address(42L);
            address.setStreet("221B Baker Street");
            Country country = new Country(11L);
            country.setName("France");
            address.setCountry(country);
            City city = new City(111L);
            city.setName("Grenoble");
            address.setCity(city);
            addressPersister.insert((Object)address);
            Address loadedAddress = (Address)addressPersister.select(address.getId());
            Assertions.assertThat((Object)loadedAddress).usingRecursiveComparison().isEqualTo((Object)address);
            Country country1 = new Country(22L);
            country1.setName("France");
            address.setCountry(country1);
            addressPersister.update((Object)address);
            loadedAddress = (Address)addressPersister.select(address.getId());
            Assertions.assertThat((Object)loadedAddress).usingRecursiveComparison().isEqualTo((Object)address);
            addressPersister.delete((Object)address);
            Assertions.assertThat((Object)addressPersister.select(address.getId())).isNull();
            Assertions.assertThat((Object)countryPersister.select(country1.getId())).isNull();
        }
    }
}

